var reviewId;
var workflowId = 0;
var editable = false;
var submitted = false;
var superUser = false;
var capriAccessParticipantsCount = 0;

//
// Start loading data: create-new-project
$(function () {
    var urlvars = getUrlVars();

    requestId = parseInt(urlvars['rid'], 10); // get the rid from the url param list, which is the requestId
    activityId = parseInt(urlvars['id'], 10); // get the id from the url param list, which is the activityId
    reviewId = parseInt(urlvars['revid'], 10); // get the reviewId from the url param list
    workflowId = parseInt(urlvars['wid'], 10); // get the workflowId from the url param list

    var activityIdMap = { "activityId": activityId };
    var requestIdMap = { "requestId": requestId };
    var userIdMap = { "userId": userId };

    //verify the Expected IRB Submission date - should not be in the past
    var expectedIRBSubmissionDate = $("#expectedIRBSubmissionDate");
    var expectedIRBSubmissionDateExpiredMessage = "The Expected IRB Submission Date has expired"
    $("#expectedIRBSubmissionDate").datepicker().on('changeDate', function () { 
    	$(this).datepicker('hide'); verifyDateForExpiration(expectedIRBSubmissionDate, expectedIRBSubmissionDateExpiredMessage ); 
    }); 

    //variables for the findPersons ajax call
    var selectedPersonName = "";
    var selectedPersonUsername = X";

    // need to know where we are for Save Draft to work
    var currSaveIndex = 0; //starting at the 1st page of the wizard
    updateSaveDraftMethod(-1, 0);

    // participantModal modal shown event listener to set default field focus
    $('#participantModal').on('shown', function() {
    	$('#name').focus();
    });

    // grab setup info from server
    $.ajax({
        url: '../dart/setup.json',
        type: 'GET',
        async: false,
        contentType: 'application/json',
		dataType:'json',
        success: function (data, textStatus, three) {
            if (textStatus === "success") {
                $('header a.active').html(data.userFullName);
                userId = data.userId;
                userIdMap['userId'] = data.userId;
                progressIncrease('60%');
                //				progressIncrease('40%');

                isDebug = data.debug;

                superUser = data.superUser;	//is this the super-user group
            }

        }
    });

    // submitting the request
    $('div.tab-study-name').on('click', 'button#submit', function (e) {
        e.preventDefault();
        $(this).hide();
        $('.submitTheRequest .progress').show();
        var submitRequest = function () {
            $.ajax({
                url: '../dart/submitRequest.json',
                type: 'POST',
                async: false,
                contentType: 'application/json',
        		dataType:'json',
                data: JSON.stringify(requestIdMap),
                success: function (data, textStatus, three) {
                    //go back to the dashboard
                    window.location = "dashboard.html#newrequest";
                }
            });
        }
        //short delay to allow UI (.progress) to catch up before submitting (IE bug fix)
        window.setTimeout(submitRequest, 100);
    });

    // populate the user request info
    $.ajax({
        url: '../dart/getActivityInfo.json',
        type: 'POST',
        contentType: 'application/json',
        async: false,
		dataType:'json',
        data: JSON.stringify(requestIdMap),
        success: function (data, textStatus, three) {

            if (data != undefined && data != null) {

                $('div.well h6.study-name').html(data.officialName);

                //$('div.tab-study-name').attr('tracking-num-content',data.trackingNumber);
                $('div.well h6.tracking-number').html(data.trackingNumber);

                //reused shortName for proposed protocol name 
                $('form.createNewProject input#shortName').val(data.shortName);

                $('form.createNewProject input#expectedIRBSubmissionDate').val(data.expectedIRBSubmissionDate);

                var expectedIRBSubmissionDate = $("#expectedIRBSubmissionDate");
                var expectedIRBSubmissionDateExpiredMessage = "The Expected IRB Submission Date has expired"
                verifyDateForExpiration(expectedIRBSubmissionDate, expectedIRBSubmissionDateExpiredMessage);
                // get and set the editable flag
                editable = data.editable;
                if( superUser == true )	//the super-user can view everything, but cannot edit
                	editable = false;
            } //end if

            progressIncrease('100%');
            $('#wizard').addClass('in');
            $('#preload').fadeOut();
        }
    });

    // populate the user request info (display the updated tracking# if this is an amendment)
    $.ajax({
        url: '../dart/getRequest.json',
        type: 'POST',
        contentType: 'application/json',
        async: false,
		dataType:'json',
        data: JSON.stringify(requestIdMap),
        success: function (data, textStatus, three) {
            if (data != null && data != undefined) {

                //$('div.tab-study-name').attr('tracking-num-content',data.trackingNumber);
                $('div.well h6.tracking-number').html(data.trackingNumber);

                // display the amendment info if this is an amendment
                displayAmendmentInfo(data);

                // get and set the editable flag (amendment might be editable even if the request is not)
                editable = data.editable;
                if( superUser == true )	//the super-user can view everything, but cannot edit
                	editable = false;
       
                var reqStatus = data.status;
                if (reqStatus != "Initiated" || data.submitted != "")
                    submitted = true;
                else
                    submitted = false;
            } //end if

        }
    });


    $("div.container a#history").click(function () {
        document.location = './history.html?id=' + activityId + '&rid=' + requestId + '&revid=' + reviewId + '&wid=' + workflowId;
    });

    $("div.container a#communication").click(function () {
        document.location = './communication.html?id=' + activityId + '&rid=' + requestId + '&revid=' + reviewId + '&wid=' + workflowId;
    });


    // populate location options
    $.ajax({
        url: '../dart/getAllLocations.json',
        type: 'POST',
        contentType: 'application/json',
        dataType:'json',
        data: JSON.stringify(requestIdMap),
        success: function (data, textStatus, three) {
            if (textStatus === "success") {

                // populate the combo box on the participants page
                var locationOptions = Mustache.render($(".locationOptionsTemplate").html(), data);
                $("div.participant-select-location .input-medium").append(locationOptions).chosen({ no_results_text: "No locations matched" });

                //TODO: not using the data sources location combo box
                //TODO: if we ever put the Data Source location back in, we need to update the Mustache template for the locationId and location name
                //// populate the combo box on the data sources page
                //locationOptions = Mustache.render($(".projectLocationsTemplate").html(),data);
                //$("form.dataSources select#location").html(locationOptions)
            }
            else {
                //TODO: error handling
            }
        }
    });

    // populate primary info data
    $.ajax({
        url: '../dart/getPrimaryInfo.json',
        type: 'POST',
        contentType: 'application/json',
        async: false,
		dataType:'json',
        data: JSON.stringify(requestIdMap),
        success: function (data, textStatus, three) {
            if (textStatus === "success") {
                primaryInfo = data;	//store the response data
                if( primaryInfo != null && primaryInfo != undefined ) {

	                if (primaryInfo.locations != null && primaryInfo.locations != undefined && primaryInfo.locations.length > 0) {

	                    populateParticipantTable(primaryInfo); //display the participant info in the table

	                    populatePrimaryInfoTable(primaryInfo);
	                }
                }
            }
        }
    });



    if (editable == false) {	//if the request is not editable, retrieve the documents for display (only once)

        // populate the document info (data sources affects the required documents)
        listDocumentsByRequest(requestId, false);


    } //end else


    //disable the page elements if this request is not currently editable
    disableAllUIControls();
    /************************ end initialize ***************/


    /************************* File Upload ****************/
    $('div.locationDocuments').on('click', 'a#uploadDocumentLink', function (e) {

        //add the docid to the modal before opening it
        var docid = $(this).attr('data-id');
        $('#uploadDocumentModal input#docid').val(docid);
    });

    $('div.participantDocuments').on('click', 'a#uploadDocumentLink', function (e) {

        //add the docid to the modal before opening it
        var docid = $(this).attr('data-id');
        $('#uploadDocumentModal input#docid').val(docid);
    });


    //TODO: if we filter by file type here, the listener probably needs to be turned on first
    //	Additional Options for the UI version:  autoUpload
    //  acceptFileTypes: /(\.|\/)(pdf|docx?)$/i,
    //  acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i,
    //  previewFileTypes: /none/,
    //?  autoUpload: false,
    //file upload
    $('#uploadDocumentModal input#fileField').fileupload({
        url: '../dart/uploadDocument.json',
        type: 'POST',
        dataType: 'text', //IE9 tries to open/save a JSON response on file upload
        forceIframeTransport: true, //same response on all browsers
        singleFileUploads: true,
        multipart: true,
        paramName: 'fileField',
        //        progressInterval: 25,
        //        bitrateInterval: 25,
        fileInput: null, //turn off the listener
        //      acceptFileTypes: /(\.|\/)(pdf|docx?)$/i,
        //        fileInput: $(this),
        //        change: function (e, data) {
        //            $.each(data.files, function (index, file) {
        //                alert('Selected file: ' + file.name);
        //            });
        //        },	//end change
        progress: function (e, data) {
            //alert("progress . . . ");

            var progress = parseInt(data.loaded / data.total * 100, 10);
            var progressPercentage = progress + '%';
            //alert("progressPercentage = " + progressPercentage);
            progressIncrease(progressPercentage);

            //progressIncrease('60%');
        },
        add: function (e, data) {
            //alert("add @fileupload (submit)");

            $.each(data.files, function (index, file) {
                //alert('Selected file: ' + file.name);
                //alert('Selected file (type): ' + file.type);

                //
                //verify the file type (pdf, doc, docx) -> rtf type == "application/msword"
                var fileNamePieces = file.name.split(".");
                var fileExt = fileNamePieces[fileNamePieces.length - 1]; //get the last .
                //alert("fileExt = " + fileExt);

                var validFileType = true;

                //only browsers with support for the File API report the type (might want to just use the fileExt value)
                if ((file.type != undefined && file.type !== "application/pdf" && file.type !== "application/msword" && file.type !== "application/vnd.openxmlformats-officedocument.wordprocessingml.document") ||
	            	(fileExt.toLowerCase() !== "pdf" && fileExt.toLowerCase() !== "doc" && fileExt.toLowerCase() !== "docx")) {

                    alert("Invalid file type.  Please select a PDF or Microsoft Word document to upload.");
                    validFileType = false;
                } //end if

                if (validFileType) {
                    $('#uploadDocumentModal').modal('hide'); //hide the modal (valid file type)

                    data.submit(); //upload the file
                } //end if

            });
        }, //end add
        submit: function (e, data) {
            //alert("submit @fileupload (do nothing for now)");

            //indicate file upload progress
            $('#preload').fadeIn();
            progressIncrease('20%');

            //testing -- don't submit the data yet
            //        	return false;
        },
        done: function (e, data) {
            //alert("done @fileupload");

            var success = false;

            if ((data != undefined && data != null) && (data.textStatus != undefined && data.textStatus != null)) {

                //TODO: if we get something other than "success" back, we probably want to display an error message
                if (data.textStatus === "success") {

                    if ((data != undefined && data != null) && (data.result != undefined && data.result != null)) {

                        //JSON response works in browsers that support XHR transport -> NOT IE9, so switching to text return type
                        //if( data.result.message.text !== "OK" ) {
                        //if (data.result !== "OK") {
                        if( data.result.indexOf("Error") != -1 ) {
                            alert(data.result); //if we got an error result, output it
                            success = false;
                        } else {
                            success = true;

                            try {
	                            var newDocId = parseInt( data.result );
	                            listDocumentById(newDocId);	//display the newly uploaded document
                            } catch(err) {
                            }
                        }
                    }
                } //end if success

            } else {
                alert("Error uploading the file.");
            }


/* testing -- instead of reloading all of the documents, only reload the newly uploaded one
            if (success) {
                //	        	//show spinner
                //	        	$('.bwizard-buttons .save a').hide();
                //	            $('.bwizard-buttons #saveLoader').removeClass('hide');
                //	        	var refreshFileList = function(){

                // populate the document info
                listDocumentsByRequest(requestId, false);


                //		    		//hide spinner
                //		    		$('.bwizard-buttons .save a').show();
                //		    	    $('.bwizard-buttons #saveLoader').addClass('hide');
                //		    	}//end refreshFileList
                //		    	//short delay to allow UI (spinner) to catch up before saving (IE bug fix)
                //		    	window.setTimeout(refreshFileList, 100);
            } //end if -- success
/* testing -- instead of reloading all of the documents, only reload the newly uploaded one */


            //clear out the selected file
            var fileControl = $('#uploadDocumentModal input#fileField');
            reset(fileControl);


            //indicate file upload progress
            progressIncrease('100%');
            $('#preload').fadeOut();
        } //end done
    });


    //clicked the File Upload submit button
    $('div#uploadDocumentModal').on('click', 'button#submit', function (e) {
        e.preventDefault(); //do not perform the form submit

        try {
            //alert("clicked the file upload submit button!");

            // Callback for the submit event of each file upload:
            // submit: function (e, data) {}, // .bind('fileuploadsubmit', func);

            $('#uploadDocumentModal input#fileField').fileupload('add', {
                fileInput: $('#uploadDocumentModal input#fileField')
            });

        } catch (err) {
            //alert("Exception: " + err);
        }
    });


    /************************* Find Persons ****************/
    //initialize the modal
    $('.participant-info').on('click', 'button[href=#participantModal]', function (e) {	//regular button
        e.preventDefault();

        //
        // clear the modal of the last search info (to match the selected search results)
        clearModalOfSearchResults();
    });

    $('.participant-info').on('click', 'a[href=#participantModal]', function (e) {	//pencil icon
        e.preventDefault();

        //
        // clear the modal of the last search info (to match the selected search results)
        clearModalOfSearchResults();
    });


    //hook the findNow button on the 'Find People' (participant) modal
    $('.modal-body').on('click', 'button#findNow', function (e) {
        e.preventDefault();

        $('div#participantModal div#resultTable .alert').hide();
        $('div#participantModal div#resultTable').addClass('hide'); //hide the results table


        var personToFindVal = $('div#participantModal input#name').val();
        var personToFindMap = { "key": personToFindVal };

        //if we have no search string, don't bother to query the server
        if (personToFindVal === "") {
            alert("Please enter a participant last name to find.");
        } else {

            $('#searchProgress').show(); //search progress bar


            //search for this person in AD
            $.ajax({
                url: '../dart/findPersons.json',
                type: 'POST',
                async: false,
                contentType: 'application/json',
                dataType:'json',
                data: JSON.stringify(personToFindMap),
                success: function (data, textStatus, three) {
                    if (textStatus === "success") {
                        if (data.persons != null) {

                            //TODO: if there are no search results, display something on the UI
                            //TODO: don't add this person if their full name starts with vha? (then it isn't actually a person)

                            //display the search results (currently: full name, username)
                            var personSearchResults = Mustache.render($(".findPersonOptionsTemplate").html(), data);
                            $('div#participantModal table tbody').html(personSearchResults);

                            //$('div#participantModal div#resultTable').fadeIn().removeClass('hide');	//show the results table
                            $('div#participantModal div#resultTable').removeClass('hide'); //show the results table


                            if (data.persons.length > 0) {
                                //TODO: make the instructions the same width as the table
                                //var tableWidth = $('div#participantModal table#sortTable').width();
                                ////$('div#participantModal div#resultTable .alert').removeClass('controls');
                                //$('div#participantModal div#resultTable .alert').width( tableWidth );
                                ////$('div#participantModal div#resultTable .alert').addClass('controls');
                                //alert("tableWidth = " + tableWidth + ", css(width) = " + $('div#participantModal table#sortTable').css('width'));
                                //alert("alert width = " + $('div#participantModal div#resultTable .alert').width() + ", css(width) = " + $('div#participantModal div#resultTable .alert').css('width'));

                                $('div#participantModal div#resultTable .alert').fadeIn(); //show the instructions for selecting a participant
                            } //end if

                        } //end if
                    } else {
                        //TODO: handle an error response
                    }
                }
            });


            $('#searchProgress').fadeOut(); //search progress bar

        } //end else
    });


    //clicked a row in the 'Find People' results table
    $('div#participantModal table').on('click', 'tr', function (e) {
        e.preventDefault();

        var selectedRow = $(this);

        //get the selected username
        selectedPersonName = $(this).find("td#fullName").text();
        selectedPersonUsername = $(this).find("td#username").text();

        displaySelectedParticipantName(); //display the selected name on the page
    });


    //clicked the cancel button -> no participant selected
    $('.modal-footer').on('click', 'button#cancel', function (e) {
        e.preventDefault();

        clearParticipantNameDisplay(); //clear the selected participant name
    });


    //create the link out of the selected participant name and display it on the page
    var displaySelectedParticipantName = function () {

        //display the selected participant
        var selectedPersonLink = Mustache.render($('.selectParticipantTemplate').html(), selectedPersonName); //display the participant name
        $('.displayTable td.primary-investigator').html(selectedPersonLink); //display the selected name on the page

        $('.displayTable td.primary-investigator').show(); //show the selected participant link
        $('#findPeopleButtonCell').hide(); //hide the "Find People" button
    };


    //Clear out the variables holding the selected person info and update the UI
    var clearParticipantNameDisplay = function () {

        selectedPersonName = "";
        selectedPersonUsername = X";

        $('.displayTable td.primary-investigator').hide(); //hide the selected participant link
        $('#findPeopleButtonCell').show(); //show the "Find People" button
    };

    //clear the modal of the last search info
    var clearModalOfSearchResults = function () {

        //
        // hide the results list
        $('div#participantModal div#resultTable .alert').hide();
        $('div#participantModal div#resultTable').addClass('hide'); //hide the results table

        //
        // clear the search name box
        $('div#participantModal input#name').val(''); //display the selected name on the page
    };

    /******************* Checkboxes *******************/
    //if the user clicks the checkbox (in the added primaryInfo), we should update the primaryInfo for this row
    $('.displayTable').on('click', 'tr#newRow input[name=notify]', function (e) {

        var thisRow = $(this).parents('tr');

        var locationCell = thisRow.find('.location-name');
        var locationName = locationCell.text();
        var locationId = locationCell.attr('data-id');

        var participantName = thisRow.find('.participant').text(); //participant name (display)

        var checkedVal = $(this).is(":checked");

        //alert("clicked the notify checkbox!, locationName = " + locationName + ", participantName = " + participantName + ", checkedVal = " + checkedVal);
        //alert("primaryInfo before = " + JSON.stringify(primaryInfo));

        //update the checkbox value for this participant name
        var investigators = primaryInfo.investigators[locationId];	//key off of the locationId

        if (investigators != undefined) {
            var participants = investigators.participants;
            if (participants != undefined) {

                for (pIndex = 0; pIndex < participants.length; pIndex++) {

                    if (participants[pIndex].name === participantName) {

                        //alert("found it!  primaryInfo participant = " + participants[pIndex].name + ", participantName = " + participantName);

                        participants[pIndex].checked = checkedVal;
                    } 
                } 
            } 
        } 
    });


    //TODO: might want to combine the body of this with the event handler for the other checkbox
    //if the user clicks the checkbox (in the added primaryInfo), we should update the primaryInfo for this row
    $('.displayTable').on('click', 'tr#newRow input[name=data-access]', function (e) {

    	var thisRow = $(this).parents('tr');

        var locationCell = thisRow.find('.location-name');
        var locationName = locationCell.text();
        var locationId = locationCell.attr('data-id');

        var participantName = thisRow.find('.participant').text(); //participant name (display)

        var dataAccessCheckedVal = $(this).is(":checked");

        //update the checkbox value for this participant name
        var investigators = primaryInfo.investigators[locationId];	//key off of the locationId

        if (investigators != undefined) {
            var participants = investigators.participants;
            if (participants != undefined) {

                for (pIndex = 0; pIndex < participants.length; pIndex++) {

                    if (participants[pIndex].name === participantName) {

                        participants[pIndex].dataAccessChecked = dataAccessCheckedVal;
                    } //end if
                } //end for
            } //end if
        } //end if

    });


    $('.displayTable').on('click', 'tr#newRow input[name=capri-access]', function (e) {

    	var thisRow = $(this).parents('tr');

        var locationCell = thisRow.find('.location-name');
        var locationName = locationCell.text();
        var locationId = locationCell.attr('data-id');

        var participantName = thisRow.find('.participant').text(); //participant name (display)

        var capriAccessCheckedVal = $(this).is(":checked");

        //update the checkbox value for this participant name
        var investigators = primaryInfo.investigators[locationId];	//key off of the locationId

        if (investigators != undefined) {
            var participants = investigators.participants;
            if (participants != undefined) {

                for (pIndex = 0; pIndex < participants.length; pIndex++) {

                    if (participants[pIndex].name === participantName) {

                        participants[pIndex].capriAccessChecked = capriAccessCheckedVal;
                        setCapriDatasourceCheckCount(capriAccessCheckedVal);
                        
                        //we auto select/deselect and enable/disable Data Access along with Capri Access
                        thisRow.find("td > .data-access").attr('checked', capriAccessCheckedVal);                        
                        participants[pIndex].dataAccessChecked = capriAccessCheckedVal;
                        thisRow.find("td > .data-access").attr('disabled',capriAccessCheckedVal);
                    } //end if
                } //end for
            } //end if
        } //end if

    });
    

    // we keep track of the number of participants that have Capri access to figue out if the
    // corresponding datasource needs to be selected
    function setCapriDatasourceCheckCount(capriAccessCheckedVal){
    	if (capriAccessCheckedVal)
    		capriAccessParticipantsCount++;
    	else
    		capriAccessParticipantsCount--;
    	
    	$('form.dataSources input[name=1001]').attr('checked', (capriAccessParticipantsCount > 0) );
    	
    	// we make sure Real SSN is checked if more than one Capri access participant exists, 
    	// however, if no Capri access participant exist we don't uncheck since we don't know if Real SSN
    	// has already been selected independent of the Capri access datasource
    	if (capriAccessParticipantsCount > 0)
    		setRealSSNIdentifier(true);    		
    }
    

    
    //Add new data row to table
    $('.displayTable').on('click', '.add', function (e) {
        e.preventDefault();

        //can only modify if the request is in an editable state
        if (editable == true) {

            //Add row
            var name = selectedPersonName;
            var username = XelectedPersonUsername;

            //var location = $("div.participant-select-location").find(".input-medium").val();	//location name
            var locationChosenBox = $("div.participant-select-location").find(".input-medium");
            var locationName = locationChosenBox.val();	//location name
            var selectedLocationId = locationChosenBox.find('option:selected').attr('data-id');	//location ID
            //alert("selectedLocationId = " + selectedLocationId);


            //
            //require a person and a location before adding the participant
            if (name === "" || name === null) {
                alert("Please select a participant.");
                return;
            }
            if (locationName === "" || locationName === null) {
                alert("Please select a participant location.");
                return;
            } //end if

            //only add this participant if unique
            var participantExists = isDuplicateParticipantUsername(primaryInfo, username);
            //alert("participant:  " + username + " @ " + locationName + ", exists = " + participantExists);

            if (participantExists) {	//only add a new participant
                alert("Please select a unique participant.");
                return;
            } //end if


            var newLocation = false;
            if (getLocInfoById(selectedLocationId) === null) {	//new location
                newLocation = true;
            }


            //keeping 2 different values for the checkboxes (notifications, data access)
            var checked = "";
            var checkedVal = ($('.displayTable .controls').find('.notify').is(":checked"));	//get the controls row checkbox values
            if (checkedVal)
                checked = "checked";

            var dataAccessChecked = "";
            var dataAccessCheckedVal = ($('.displayTable .controls').find('.data-access').is(":checked"));
            if (dataAccessCheckedVal)
                dataAccessChecked = "checked";


            //
            //primary investigator defaults to both checkboxes being checked
            if (newLocation) {
                checkedVal = true;
                checked = "checked";

                dataAccessCheckedVal = true;
                dataAccessChecked = "checked";
            }

            
            var dataAccessEnabled = "";
            var capriAccessEnabled = "";
            
            var capriAccessChecked = "";
            var capriAccessCheckedVal = ($('.displayTable .controls').find('.capri-access').is(":checked"));
            if (capriAccessCheckedVal){
                capriAccessChecked = "checked";
                dataAccessChecked = "checked";
                dataAccessEnabled = "disabled";
                dataAccessCheckedVal = true;
                setCapriDatasourceCheckCount(capriAccessCheckedVal);
            }
            
            //create a row for this data and add it to the table
            createAndAddRowToDisplayTable(name, username, locationName, selectedLocationId, checked, dataAccessChecked, capriAccessChecked, dataAccessEnabled, capriAccessEnabled);



            //send the new row to primaryInfo object
            if (newLocation) {	//new location

                //if this is the only location, default to primary site
                var isPrimary = false;
                if (primaryInfo.locations.length === 0) {
                    isPrimary = true;
                }
                primaryInfo.locations.push({ "primary": isPrimary, "location": locationName, "locationId": selectedLocationId, "primaryInvestigator": name, "primaryInvestigatorUserId": username });

                primaryInfo.investigators[selectedLocationId] = { "participants": [{ "name": name, "username": username, "checked": checkedVal, "dataAccessChecked": dataAccessCheckedVal, "capriAccessChecked":capriAccessCheckedVal}] };

            } else {

                //assumed that if it is not a new location then it can only be a new person
                primaryInfo.investigators[selectedLocationId].participants.push({ "name": name, "username": username, "checked": checkedVal, "dataAccessChecked": dataAccessCheckedVal, "capriAccessChecked":capriAccessCheckedVal });
            }


            //refresh the primaryInfo table when adding a new participant (even if this is just a new person, and not a new location)
            populatePrimaryInfoTable(primaryInfo); //update the display


            //clear old data
            $("div.participant-select-location").find(".input-medium").val("").trigger('liszt:updated');
            clearParticipantNameDisplay(); //clear the selected participant name
            

        } //end if -- editable
    });

    //Remove data row from table
    $('.displayTable').on('click', '.delete', function (e) {
        e.preventDefault();

        //can only modify if the request is in an editable state
        if (editable == true) {

            var thisRow = $(this).parents('tr');

            var locationCell = thisRow.find('.location-name');
            var locationName = locationCell.text();
            var locationId = locationCell.attr('data-id');

            var participant = thisRow.find('.participant').text(); //participant name (display)

            var locationData = getLocInfoById(locationId);

            //remove name from investigator's list
            primaryInfo.investigators[locationId].participants = removeParticipantFromArray(participant, primaryInfo.investigators[locationId].participants);

            //check if we should also remove a primary location
            if (primaryInfo.investigators[locationId].participants.length === 0) {	//no more participants at this site

                //are we deleting the primary site?
                var deletingPrimarySite = false;
                $.each(primaryInfo.locations, function (i, val) {
                    if (locationId == val.locationId && primaryInfo.locations[i].primary == true) {	//primary site?  (match the locationId)
                        deletingPrimarySite = true; //about to delete the primary site
                    } //end if
                });

                delete primaryInfo.investigators[locationId];
                primaryInfo.locations.splice(locationData.i, 1);

                //if we just deleted the primary site, set the 1st site in the list to primary
                if (deletingPrimarySite) {
                    if (primaryInfo.locations.length > 0) {
                        primaryInfo.locations[0].primary = true;
                    } //end if
                } //end if

            } else {
                //if we just deleted the primaryInvestigator, default to the 1st remaining participant
                if (participant === locationData.primaryInvestigator) {
                    var newPrimaryInvestigatorName = primaryInfo.investigators[locationId].participants[0].name;
                    var newPrimaryInvestigatorUsername = primaryInfo.investigators[locationId].participants[0].username;

                    primaryInfo.locations[locationData.i].primaryInvestigator = newPrimaryInvestigatorName;
                    primaryInfo.locations[locationData.i].primaryInvestigatorUserId = newPrimaryInvestigatorUsername;

                    //if we change the primary investigator, default to both checkboxes being checked (for the new primary investigator)
                    updatePrimaryInvestigatorCheckboxValues(primaryInfo.investigators[locationId].participants, newPrimaryInvestigatorName, newPrimaryInvestigatorUsername, locationName, locationId);
                }
            }

            //refresh the primaryInfo table when deleting a participant
            populatePrimaryInfoTable(primaryInfo); //update the display
            if (primaryInfo.locations.length === 0) {	//no sites left, so update the CSS
                $('.primary-info').css('opacity', .3);
                $('.primary-info .alert').hide();
            }

            thisRow.fadeOut('fast', function () { $(this).remove(); });

        } //end if -- editable
    });

    //Change Primary Location
    $('.primary-info').on('click', 'td.primary-location i', function (e) {

        //can only modify if the request is in an editable state
        if (editable == true) {

            //var location = $(this).parents('tr').find('td.location-name').text();
            var locationCell =  $(this).parents('tr').find('td.location-name');
            var locationName = locationCell.text();
            var locationId = locationCell.attr('data-id');

            $('td.primary-location i').removeClass('icon-star').addClass('icon-star-empty');
            $(this).removeClass('icon-star-empty').addClass('icon-star');

            $.each(primaryInfo.locations, function (i, val) {
                if( locationId == val.locationId ) {	//match the locationId
                    primaryInfo.locations[i].primary = true;
                } else {
                    primaryInfo.locations[i].primary = false;
                }
            });

        } //end if -- editable
    });

    //Change Primary Investigator
    $('.primary-info').on('click', '.edit-primary-investigator', function (e) {
        e.preventDefault();

        //can only modify if the request is in an editable state
        if (editable == true) {

            var selected = $(this);

            var locationCell = selected.parents('tr').find('td.location-name');
            var locationName = locationCell.text();
            var locationId = locationCell.attr('data-id');

            var locationData = getLocInfoById(locationId);

            var participants = primaryInfo.investigators[locationId];

            var piOptions = Mustache.render($('.piOptionsTemplate').html(), participants); //display the participant name
            var curPI = 'option[value="' + locationData.primaryInvestigator + '"]';
            piOptions = $(piOptions).find(curPI).attr("selected", true).end();

            selected.parents('tr').find('.primary-investigator').html(piOptions).find('select').on('change', function (e) {

                var name = $(e.target).val();
                var username = getUsername(participants.participants, name); //get the username that corresponds to this name

                locationData.primaryInvestigator = name;
                locationData.primaryInvestigatorUserId = username;

                //if we change the primary investigator, default to both checkboxes being checked (for the new primary investigator)
                updatePrimaryInvestigatorCheckboxValues(participants.participants, name, username, locationName, locationId);

                populatePrimaryInfoTable(primaryInfo);
            });

            $('.piSelect').on('blur', function (e) {	//loss of focus on the drop-down
                //alert("blur!!!!");
                //TODO: trigger the close button event here? (function, below)
            });

            $('.primary-info').on('click', '.primary-investigator button.close', function (e) {	//clicked the close button
                populatePrimaryInfoTable(primaryInfo);
            });

        } //end if -- editable
    });


    //retrieve the JSON for this location, based on the given location name
    var getLocInfo = function (locationName) {
        var locationData = null; //default to null
        $.each(primaryInfo.locations, function (i, val) {
            //alert(i + ": " + val.location);

            if (locationName === val.location) {
                locationData = primaryInfo.locations[i];
                locationData["i"] = i;
            }
        });
        return locationData;
    };

    //retrieve the JSON for this location, based on the given locationId
    var getLocInfoById = function (locationId) {
        var locationData = null; //default to null
        $.each(primaryInfo.locations, function (i, val) {
            //alert(i + ": " + val.location + ", " + val.locationId);

            if (locationId == val.locationId) {	//match the locationId
            	//alert("found the location id:  " + locationId + ", index = " + i);

                locationData = primaryInfo.locations[i];
                locationData["i"] = i;
            }
        });
        return locationData;
    };


    // populate the data source table
    $.ajax({
        url: '../dart/getAllDataSources.json',			//getAllDataSourcesBySection.json
        type: 'POST',
        contentType: 'application/json',
		dataType:'json',
        data: JSON.stringify(userIdMap),				//JSON.stringify(requestIdMap)
        success: function (data, textStatus, three) {
            if (textStatus === "success") {
                var rlist = data.dataSources;
                if (rlist.length > 0) {

                    //TODO: for now, using static checkbox values (will probably want to update the model, eventually)
                    //var tableBody = Mustache.render($(".dataSourceRowTemplate").html(),data);
                    //$('form.dataSources div.dataSourcesList').html(tableBody);


                    //Note: not currenty using this source name options list?
                    //// figure out the list of distinct data source names
                    //var sourceNameList = [];
                    //var distinctNameList = [];
                    //for (var i in rlist) {
                    //	var nValue = rlist[i].name;
                    //	if ($.inArray(nValue, distinctNameList) == -1) {
                    //		distinctNameList.push(nValue);
                    //		var obj = {"name":nValue};
                    //		sourceNameList.push(obj);
                    //	}
                    //}
                    //
                    //var sourceObj = {"sources":sourceNameList};
                    //var optionsList = Mustache.render($(".dsNameOptionTemplate").html(),sourceObj);
                    //$('form.dataSources select#dataSource').html(optionsList);


                    // populate the activity data sources info
                    $.ajax({
                        url: '../dart/getRequestDataSources.json',
                        type: 'POST',
                        contentType: 'application/json',
                		dataType:'json',
                        data: JSON.stringify(requestIdMap),
                        async: false,
                        success: function (data, textStatus, three) {
                            if (textStatus === "success") {

                                //set the data location
                                setSelectedDataSourceLocation(data);

                                //selected data source options
                                setSelectedDataSources(data);

                                //identifier checkboxes
                                setRealSSNIdentifier( data.realSSNIdentifier );
                                setScrambledSSNIdentifier( data.scrambledSSNIdentifier );
                                setPHIIdentifier( data.phiDataIdentifier );
                            } //end if
                        }
                    });
                }//end if -- rlist.length
            }
        }
    });


    //Note: only retrieve the list of documents just before moving to the Documents tab? (we only allow linear movement through the wizard)
    //	// populate the document info (trying synchronous to see if this will solve the document issues with primaryInfo)
    //	listDocumentsByRequest( requestId, false );	//synchronous


    removeFromArray = function (value, arr) {
        return $.grep(arr, function (elem, index) {
            return elem !== value;
        });
    };

});
/*****************************/
/*****************************/
/** End Init function ********/
/*****************************/
/*****************************/


//displays the amendment narrative if this is an amendment
displayAmendmentInfo = function (data) {

    if (data != undefined && data != null) {

        //amendment tracking#:  yyyy-mm-#-type-A#
        if( data.amendment == true || (data.trackingNumber != undefined && data.trackingNumber != null && (data.trackingNumber.indexOf("-A") > -1)) ) {	//amendment

            //
            //show/hide the amendment narrative
            var amendNarrative = Mustache.render($(".amendNarrativeTemplate").html(), data.amendmentNarrative);
            $('div.tab-study-name div.narrative').html(amendNarrative);

            $('div.tab-study-name div.narrative').show(); //amendment
        } else {
            $('div.tab-study-name div.narrative').hide(); //NOP InIa endment
        }
    } //end if
};


//removes the participant from the investigators array, by participant name
removeParticipantFromArray = function (value, arr) {
    return $.grep(arr, function (elem, index) {
        if (elem != null && elem.name != null) {
            return elem.name !== value;
        }

        return null;
    });
};


populatePrimaryInfoTable = function (primaryInfo) {
    var newPrimary = Mustache.render($(".newPrimaryTemplate").html(), primaryInfo);
    $('.primary-info table tbody').html(newPrimary);
    if (primaryInfo.locations.length > 0) {
        $('.primary-info :checked').siblings().first().removeClass('icon-star-empty').addClass('icon-star');
        $('.primary-info').css('opacity', 1);
        $('.primary-info .alert').fadeIn();
    }
};


//Displays the primaryInfo participant data in the participant table
populateParticipantTable = function (primaryInfo) {

    if (primaryInfo != undefined && primaryInfo != null) {

        for (idx in primaryInfo.locations) {
            var loc = primaryInfo.locations[idx];
            var locationName = loc.location; //location name
            var locationId = loc.locationId;

            if (loc.primaryInvestigator === null) {
                loc.primaryInvestigator = "TEST";
            } //end if


            var investigators = primaryInfo.investigators[locationId];	//key off of the locationId
            if (investigators != undefined) {

                var participants = investigators.participants;
                if (participants != undefined) {

                    //alert("have some participants! length = " + participants.length);
                    //alert("participants: " + JSON.stringify(participants));

                    for (var pIndex = 0; pIndex < participants.length; pIndex++) {

//                        if (participants[pIndex].name === null) {
//                            participants[pIndex].name = "TEST";
//                        }

                        //create a row for this data and add it to the table
                        var name = participants[pIndex].name;
                        var username = participants[pIndex].username;
                        var checked = (participants[pIndex].checked) ? "checked" : "";
                        var dataAccessChecked = (participants[pIndex].dataAccessChecked) ? "checked" : "";
                        var capriAccessChecked = (participants[pIndex].capriAccessChecked) ? "checked" : "";
                        
                        
                        var dataAccessEnabled = "";
                        var capriAccessEnabled = "";
                        
                        // Checking Capri Access means Data Access will also be selected and disabled
                        if (participants[pIndex].capriAccessChecked){
                        	participants[pIndex].dataAccessChecked = true;
                     	   dataAccessChecked = "checked";
                     	   dataAccessEnabled = "disabled";
                        }
                              
                                        
// No way of providing this functionality with the available data left the code in case we find a way to do it                         
//                        // if Data Access or Capri Access have been checked on original request, 
//                        // when don't allow the un-checking when it becomes an amendment 
//                        if (primaryInfo.amendment){
//                        	if (participants[pIndex].dataAccessChecked){
//                        		dataAccessEnabled = "disabled";
//                        	}
//                        	if (participants[pIndex].capriAccessChecked){
//                        		dataAccessEnabled = "disabled";
//                        		capriAccessEnabled = "disabled";                        		
//                        	}
//                        }
                        
                        
                        createAndAddRowToDisplayTable(name, username, locationName, locationId, checked, dataAccessChecked, capriAccessChecked, dataAccessEnabled, capriAccessEnabled);
                        
                        //check the Capri Vista datasource if at least one participants has the capri access option checked
                        if (capriAccessChecked == "checked") {
                        	$('form.dataSources input[name=1001]').attr('checked', 'checked');
                        	capriAccessParticipantsCount++;
                        	// we auto select Real SSN Identifier
                        	setRealSSNIdentifier(true);                       	
                        }
                    } //end for
                    // Capri VistAWeb Acces datasource selection is now based on participant's Capri Access selection
                    $('form.dataSources input[name=1001]').attr('checked', (capriAccessParticipantsCount > 0) );
                    
                } //end if
            } //end for
        } //end for
    } //end if
};



//Creates a row out of the specified values and adds this new row to the participants table
createAndAddRowToDisplayTable = function (name, username, locationName, locationId, checkedVal, dataAccessCheckedVal, capriAccessCheckedVal, dataAccessEnableVal, capriAccessEnableVal) {

    var data = {
        "name": name,
        "username": username,
        "location": locationName,
        "locationId": locationId,
        "checked": checkedVal,
        "dataAccessChecked": dataAccessCheckedVal,
        "capriAccessChecked": capriAccessCheckedVal,
        "dataAccessEnabled": dataAccessEnableVal,
        "capriAccessEnabled": capriAccessEnableVal        
    };
    var newRow = Mustache.render($(".newRowTemplate").html(), data);

    $('.displayTable .controls').before(newRow);
    $('.displayTable tr.hide').fadeIn().removeClass('hide');
};



//Returns the username that corresponds to this name (in the list of participants)
getUsername = function(participants, participantName) {

    if (participants != undefined) {

        for (var pIndex = 0; pIndex < participants.length; pIndex++) {

            if (participants[pIndex].name === participantName) {	//match the participant by name
                return (participants[pIndex].username);
            } //end if

        } //end for
    } //end if

    return "";
};


//returns true if this username is found at this location
isParticipantUsernameAtLocation = function (participants, participantUsername) {

    if (participants != undefined) {

        for (var pIndex = 0; pIndex < participants.length; pIndex++) {

        	var currUsername = participants[pIndex].username.toUpperCase().trim();
        	var usernameToCompare = participantUsername.toUpperCase().trim();

        	if (currUsername =XX usernameToCompare) {	//match the participant by username
                return true;
            } //end if

        } //end for
    } //end if

    return false;
};


//returns true if this username is found at ANY location
isDuplicateParticipantUsername = XXXXXXXX (primaryInfo, username) {

    if (primaryInfo != undefined && primaryInfo != null) {

        for (idx in primaryInfo.locations) {
            var loc = primaryInfo.locations[idx];

            //var locationName = loc.location; //location name
            var locationId = loc.locationId;

            var investigators = primaryInfo.investigators[locationId];	//key off of the locationId
            if (investigators != undefined) {

                var foundParticipant = isParticipantUsernameAtLocation(investigators.participants, username);
                if (foundParticipant)	//this participant is already in the primaryInfo
                    return true;

            } //end if
        } //end for -- locations
    } //end if

    return false;
};


//the principalInvestigator defaults to notifications and data access (update the primaryInfo and the checkboxes)
updatePrimaryInvestigatorCheckboxValues = function (locationParticipants, participantName, participantUsername, locationName, locationId) {

    if (locationParticipants != null && locationParticipants != undefined) {

        //alert("locationParticipants = " + JSON.stringify(locationParticipants));

        for (var pIndex = 0; pIndex < locationParticipants.length; pIndex++) {

            //alert("pIndex = " + pIndex);
            //alert("locationParticipants[pIndex].name = " + locationParticipants[pIndex].name);

            if (locationParticipants[pIndex].username.toUpperCase().trim() === participantUsername.toUpperCase().trim()) {	//match the participant by username

                //primaryInvestigator defaults to true on both the notifications and data access
                locationParticipants[pIndex].dataAccessChecked = true;
                locationParticipants[pIndex].checked = true;
            } //end if
        } //end for
    } //end if


    //update the participants table
    $('.displayTable tr#newRow').each(function () {

        //find this participant at this location
        var currParticipantName = $(this).find("td.participant").text();

        var currLocationCell = $(this).find("td.location-name");
        var currLocationName = currLocationCell.text();
        var currLocationId = currLocationCell.attr('data-id');

        if (currParticipantName.toUpperCase().trim() === participantName.toUpperCase().trim() && currLocationId == locationId) {	//match locationId
            $(this).find('input[name=notify]').attr('checked', 'checked'); //set the checkbox value
            $(this).find('input[name=data-access]').attr('checked', 'checked');
        } //end if
    });
};


//Read a page's GET URL variables and return them as an associative array.
getUrlVars = function () {
    var vars = [], hash;
    var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
    for (var i = 0; i < hashes.length; i++) {
        hash = hashes[i].split('=');
        vars.push(hash[0]);
        vars[hash[0]] = hash[1];
    }
    return vars;
}


//called from the bwizard to validate page changes when next or back are clicked
wizardValidating = function (e, ui) {
    // ui.index is the index of the visible panel starting from 0
    // e is the javascript event that (eventually) caused this function all.  The event is cancellable with its returnValue property.

    //alert("index = " + ui.index + ", nextIndex = " + ui.nextIndex);

    //
    //save before moving to the next/prev page
    var movingToNextPage = (ui.nextIndex > ui.index); //which direction are we moving?
    var resultCode = saveWizardPage(ui.index, movingToNextPage);

    updateSaveDraftMethod(ui.index, ui.nextIndex); //show/hide the Save Draft button and update the page index
}


////Allow the wizard panel headings to be clickable (move the page within the wizard, calls the wizardValidating function)
//$('#wizard').on('click', 'li#Information', function(e){
//	$('#wizard').bwizard("show", 0);
//});
//$('#wizard').on('click', 'li#Participants', function(e){
//	$('#wizard').bwizard("show", 1);
//});
//$('#wizard').on('click', 'li#Data', function(e){
//	$('#wizard').bwizard("show", 2);
//});
//$('#wizard').on('click', 'li#Documents', function(e){
//	$('#wizard').bwizard("show", 3);
//});
//$('#wizard').on('click', 'li#Submit', function(e){
//	$('#wizard').bwizard("show", 4);
//});


// as bwizard does not provide a built-in function to track "where" in the wizard we are, or from which direction we're getting there
// we need to manually identify and maintain these values...
updateSaveDraftMethod = function (currIndex, nextIndex) {

    //
    //remember where we are moving to for "Save as Draft" (once that button is rendered, we're at the next page)
    currSaveIndex = nextIndex;

    //
    //show/hide the save button, based on which page we're moving to: nextIndex
    if (currIndex == -1 || nextIndex == 0) {	//at the first page of the wizard
        $('.save').show(); // show everything
    }
    else if (nextIndex == 1) {
        $('.save').show(); // show everything
    }
    else if (nextIndex == 2) {
        $('.save').show(); // show everything
    }
    else if (nextIndex == 3) {
        $('.save').show(); // show everything
    }
    else if (nextIndex == 4) {
        $('.save').hide(); // show nothing
    }
}

saveProjectInformation = function (requestId) {
    // populate the user request info
    var aiMap = { "requestId": requestId };

    aiMap['shortName'] = $('form.createNewProject input#shortName').val().trim(); 		// trim whitespace
    aiMap['expectedIRBSubmissionDate'] = $('form.createNewProject input#expectedIRBSubmissionDate').val();
    // we don't allow modifying these values here even if they are passed to the server
    aiMap['officialName'] = '';
    aiMap['draft'] = true;
    aiMap['type'] = '';

    // actually, I want this to be synchronous
    $.ajax({
        url: '../dart/saveActivityInfo.json',
        type: 'POST',
        async: false,
        contentType: 'application/json',
		dataType:'json',
        data: JSON.stringify(aiMap),
        success: function (data, textStatus, three) {
            if (textStatus === "success") {
                if (data.message.text !== "OK") {
                    //alert(data.message.text);
                    return -1;
                }

                return 0;
            }
            else {
                alert('error');
                return -1;
            }
        }
    });
}

saveParticipantInformation = function (reqestId) {
    // save participant info
    var piMap = { "requestId": requestId };

    // make a deep copy of the primary info to manipulate before sending to the server
    var newPrimaryInfo = jQuery.extend(true, {}, primaryInfo);
    piMap['primaryInfo'] = newPrimaryInfo;

    // remove any 'i' property in the location map
    for (idx in newPrimaryInfo.locations) {
        var loc = newPrimaryInfo.locations[idx];
        delete loc.i;	//remove the extra index info


        //primaryInvestigator defaults to true on both the notifications and data access
        var investigators = newPrimaryInfo.investigators[loc.locationId];	//key off of the locationId

        if (investigators != undefined) {
            var participants = investigators.participants;
            //alert("participants before = " + JSON.stringify(participants));
            //alert("primaryInvestigator for location: " + loc.location + " = " + loc.primaryInvestigatorUserId);

            if (participants != undefined) {
                for (var pIndex = 0; pIndex < participants.length; pIndex++) {

                    if (participants[pIndex].username =XX loc.primaryInvestigatorUserId) {

                        //primaryInvestigator defaults to true on both the notifications and data access
                        participants[pIndex].dataAccessChecked = true;
                        participants[pIndex].checked = true;
                    } //end if

                } //end for
            } //end if

            //alert("participants after = " + JSON.stringify(participants));
        } //end if
    } //end for

    // actually, I want this to be synchronous
    $.ajax({
        url: '../dart/savePrimaryInfo.json',
        type: 'POST',
        async: false,
        contentType: 'application/json',
		dataType:'json',
        data: JSON.stringify(piMap),
        success: function (data, textStatus, three) {
            if (textStatus === "success") {

                //Note:  we are not currently allowing non-linear movement through the wizard, so this call is extra
                //testing -- if the user changed the primaryInfo, this might affect the required documents (might want to move this to the validating function -> where are we moving next?)
                //// populate the document info (primaryInfo affects the required documents)
                //listDocumentsByRequest( requestId, false );
            }
        }
    });
}


updateDocumentInfo = function( documentRowData, documentHeadId ) {

	if( documentInfo != null && documentInfo != undefined ) {

		//check the location documents
	    for (idx in documentInfo.locations) {
	        var loc = documentInfo.locations[idx];

	        var documents = loc.documents;
	        if (documents != undefined) {
		        for (var docIndex = 0; docIndex < documents.length; docIndex++) {
                    if (documents[docIndex].headId === documentHeadId) {

                    	documents[docIndex] = documentRowData;	//store this new row in the overall JSON structure
                    	return;
                    }
		        }
	        }
	    }//end for

		//check the participant documents
	    for (idx in documentInfo.participants) {
	        var loc = documentInfo.participants[idx];

	        var documents = loc.documents;
	        if (documents != undefined) {
		        for (var docIndex = 0; docIndex < documents.length; docIndex++) {
                    if (documents[docIndex].headId === documentHeadId) {

                    	documents[docIndex] = documentRowData;	//store this new row in the overall JSON structure
                    	return;
                    }
		        }
	        }
	    }//end for

	}//end if
}

//returns true if the specified section of documents have all been uploaded
allDocsUploaded = function( isLocationDoc ) {

	if( documentInfo != null && documentInfo != undefined ) {

		if( isLocationDoc === true ) {	//check the location documents

		    for (idx in documentInfo.locations) {
		        var loc = documentInfo.locations[idx];

		        var documents = loc.documents;
		        if (documents != undefined) {
			        for (var docIndex = 0; docIndex < documents.length; docIndex++) {
	                    if (documents[docIndex].uploaded === false) {
	                    	return false;
	                    }
			        }
		        }
		    }//end for

		} else {	//check the participant documents

		    for (idx in documentInfo.participants) {
		        var loc = documentInfo.participants[idx];

		        var documents = loc.documents;
		        if (documents != undefined) {
			        for (var docIndex = 0; docIndex < documents.length; docIndex++) {
	                    if (documents[docIndex].uploaded === false) {
	                    	return false;
	                    }
			        }
		        }
		    }//end for

		}//end else

	}//end if

	return true;
}

//get the document for this documentId (display the newly uploaded document)
listDocumentById = function (documentHeadId) {

    var documentIdMap = { "documentId": documentHeadId };

    // populate the document info
    $.ajax({
        url: '../dart/listDocumentById.json',
        type: 'POST',
        async: false,
        contentType: 'application/json',
		dataType:'json',
        data: JSON.stringify(documentIdMap),
        success: function (data, textStatus, three) {
            if (textStatus === "success") {

//testing -- handled by the DocumentController now
//                //only allow document uploads if this request is editable and if the document is editable (returned by the Controller)
//                if (data != undefined && data != null) {
////                    data['editable'] = editable;	//editable logic determined by the Controller
//
//                    //super-user cannot edit the request (including upload)
//                    if( superUser == true ) {
//                    	data['editable'] = false;
//                    }//end if
//                } //end if


                //display the newly uploaded document
                var docRowBody = Mustache.render($(".newDocumentRowTemplate").html(), data);
                var uploadedDocRow = $('#' + documentHeadId);
                uploadedDocRow.html(docRowBody);

                var isLocationDoc = uploadedDocRow.hasClass('location');	//which section is this document in? location vs. participant

                //update the stored JSON -- have all documents been uploaded yet?
                updateDocumentInfo( data, documentHeadId );
                var uploaded = allDocsUploaded( isLocationDoc );
                if( uploaded ) {

                	//determine if all of the documents are uploaded (display the checkmark)
	                try {
	                	var currParent = uploadedDocRow.closest('div[class="accordion-group"]');	//get the parent
	                	if( currParent != null && currParent != undefined ) {
	                		currParent.find('i.icon-ok-sign').removeClass('hide');	//show the check-box
	                	}//end if
	                } catch( err ) {
	                	//alert("Error:  " + err);
	                }

                }//end if uploaded
            }//end if success

            //TODO: display something if we get an error back from the server?  (Error retrieving documents)

        } //end success
    });
}

//get the documents by requestId
listDocumentsByRequest = function (requestId, asyncVal) {

    var requestIdMap = { "requestId": requestId };

    // populate the document info
    $.ajax({
        url: '../dart/listDocumentsByRequest.json',
        type: 'POST',
        async: asyncVal,
        contentType: 'application/json',
		dataType:'json',
        data: JSON.stringify(requestIdMap),
        success: function (data, textStatus, three) {
            if (textStatus === "success") {

                //required documents
                var accordionBody = Mustache.render($(".documentLocationsTemplate").html(), data);
                $('div.tab-study-name div#accordionR .locationDocuments').html(accordionBody);

                accordionBody = Mustache.render($(".documentParticipantsTemplate").html(), data);
                $('div.tab-study-name div#accordionR .participantDocuments').html(accordionBody);

                // TODO- populate rows with electronic documents

                //
                //on expand/collapse, update the caret icon
                initExpandCollapseIconActions();

                //save the document JSON
                documentInfo = data;
            }

            //TODO: display something if we get an error back from the server?  (Error retrieving documents)

        } //end success
    });
}

var getSelectedDataSourceLocation = function () {

    var dataLoc = new Object();

    var dataSourceDest1 = $('form.dataSources .dataSourceDestinations input.dataLocation1').is(':checked');

    dataLoc['dataMart'] = dataSourceDest1;

    return dataLoc;
};

var setSelectedDataSourceLocation = function (data) {

    if (data != null && data != undefined) {

    	if( data.dataMart ) {	//VINCI
    		$('form.dataSources input.dataLocation1').attr('checked', 'checked');
        }
    	
    } //end if
};

/*Data Location*/
$("#rdlocalServerLocation").change(function() {
	showServerLocation(this.checked); //show/hide the local server location
});



var getSelectedDataSourceIDList = function () {

    var dataSources = [];

    //TODO: for now, using static checkbox values (will probably want to update the model, eventually
    //	$('.dataSourcesList input:checked').each(function() {
    //		$this = $(this);
    //		var id = $this.attr('data-id');
    //		dataSources.push(parseInt(id,10));
    //	});

    $('form.dataSources input[type=checkbox]:checked').each(function () {
        $this = $(this);
        var id = $this.attr('data-id');

        if (id != null && id != undefined) {
            var dataSourceId = parseInt(id, 10);
            if ($.inArray(dataSourceId, dataSources) == -1) {	//only keep unique ID values
                dataSources.push(dataSourceId);
            }
        } //end if
    });



    return dataSources;
};


//If the specified data source is checked, update the corresponding data source identifier checkboxes (only on check, NOT on un-check)
//	These Data Source ID values are based on the name/ID values in the HTML (currently static, so we're just using them directly here too)
var updateDataSourceIdentifiers = function ( dataSourceId ) {

	//alert("updateDataSourceIdentifiers(),  dataSourceId = " + dataSourceId);

//Scrambled SSN
	//Vital Status Files with Scrambled SSN (SAS format) -> Scrambled SSN (6)
	if( dataSourceId === "6" ) {
		setScrambledSSNIdentifier( true );
	}


//Real SSN
	//TIU Text Notes (Requires Real SSN Approval) -> Real SSN (1025)
	//Vital Status File Real SSN Crosswalk File -> Real SSN (3)
	//BIRLS Real SSN (110JJ02) -> Real SSN (7)
	//MedSAS including VetsNet Files for National Level Real SSN (1100TT01) -> Real SSN
	//MedSAS Files for VISN Level Real SSN (1100TT05) -> Real SSN
	//CAPRI/VistAWeb (Requires Real SSN Approval) -> Real SSN
	//DSS Web Reports -> Real SSN
	//VSSC Web Reports -> Real SSN
	//Vital Status File Real SSN Crosswalk File (110TT20) -> Real SSN
	else if( dataSourceId === "1025" ||
			dataSourceId === "3" ||
			dataSourceId === "7" ||
			dataSourceId === "1030" ||
			dataSourceId === "1031" ||
			dataSourceId === "1001" ||
			dataSourceId === "8" ||
			dataSourceId === "13" ||
			dataSourceId === "11" ) {

		setRealSSNIdentifier( true );
	}


	//Vital Status Files with Scrambled SSN (110NN06) -> Scrambled SSN ( if Vital Status File Real SSN Crosswalk File (110TT20) has been checked, scrambled SSN does not need to be checked )
	else if( dataSourceId === "12" ||
			(dataSourceId === "1036" && !getRealSSNIdentifier())) {

//performed at verification step:  Scrambled SSN ( if Vital Status File Real SSN Crosswalk File (110TT20) has been checked, scrambled SSN does not need to be checked )

		setScrambledSSNIdentifier( true );
	}
}


var setScrambledSSNIdentifier = function( checkedVal ) {

    if (checkedVal) {
        $('form.dataSources input#scrambledSSNIdentifier').attr('checked', 'checked');
    }
    else {
        $('form.dataSources input#scrambledSSNIdentifier').removeAttr('checked');
    }
}

var setRealSSNIdentifier = function( checkedVal ) {

    if (checkedVal) {
        $('form.dataSources input#realSSNIdentifier').attr('checked', 'checked');
    }
    else {
        $('form.dataSources input#realSSNIdentifier').removeAttr('checked');
    }

}

getRealSSNIdentifier = function() {
	
	var isChecked = $('form.dataSources input#realSSNIdentifier').attr('checked');
	
	return (isChecked === "checked");
}

var setPHIIdentifier = function( checkedVal ) {

    if (checkedVal) {
        $('form.dataSources input#phiIdentifier').attr('checked', 'checked');
    }
    else {
        $('form.dataSources input#phiIdentifier').removeAttr('checked');
    }
}

var hideDataSources = function( dataSourcesList ) {

    if (dataSourcesList != undefined && dataSourcesList != null) {

	    var rlistDS = dataSourcesList;
	    if (rlistDS.length > 0) {
	        for (var i in rlistDS) {
	            var dsId2 = rlistDS[i];

	            // hide the data source
	            $('form.dataSources label[for="' + dsId2 + '"]').hide();
	        }
	    } //end if

    }//end if
};


//disable the data sources that correspond to workflows that are not currently editable
//disable the data sources that have already been approved (do not allow the user to remove previously approved data sources)
var disableDataSources = function( dataSourcesList ) {

    if (dataSourcesList != undefined && dataSourcesList != null) {

	    var rlistDS = dataSourcesList;
	    if (rlistDS.length > 0) {
	        for (var i in rlistDS) {
	            var dsId2 = rlistDS[i];
	
	            // disable the data source checkbox
	            $('form.dataSources input[name=' + dsId2 + ']').attr('disabled', 'disabled');
	        }
	    } //end if

    }//end if
};


var checkSelectedDataSources = function( dataSourcesList ) {

    //mark the selected data sources
    if (dataSourcesList != undefined && dataSourcesList != null) {

        var rlist2 = dataSourcesList;
        if (rlist2.length > 0) {
            for (var i in rlist2) {
                var dsId2 = rlist2[i];

                // find the data source row and check its checkbox
                //$('.dataSourcesList input[name='+dsId2+']').attr('checked','checked');
                $('form.dataSources input[name=' + dsId2 + ']').attr('checked', 'checked');
            }
        } //end if

    } //end if
};

var setSelectedDataSources = function (data) {

	//we always disable the Capri VistAWeb Acces datasource
	$('form.dataSources input[name=1001]').attr('disabled', 'disabled');
	
	if( data != undefined && data != null ) {

	    //mark the selected data sources
	    checkSelectedDataSources( data.dataSources );
	    
	    //disable the data sources that correspond to workflows that are not currently editable
	    if (data.lockedDataSources != undefined && data.lockedDataSources != null) {
	    	disableDataSources( data.lockedDataSources );
	    }//end if    
	    
	    //
	    //disable the data sources that have already been approved (do not allow the user to remove previously approved data sources)
	    if (data.approvedDataSources != undefined && data.approvedDataSources != null) {
	    	disableDataSources( data.approvedDataSources );

	    	//select the previously approved data sources, just in case they're not yet selected
	    	checkSelectedDataSources( data.approvedDataSources );
	    }//end if
	    
	}//end if -- data


    //
    //when a data source is selected, update the corresponding identifiers
    $('form.dataSources input[type=checkbox]').on('click', function (e) {

        var checkedVal = $(this).is(":checked");
        if( checkedVal ) {
        	var dataSourceId = $(this).attr('data-id');	//data-id, name, and id are all the same here

        	if( dataSourceId != undefined ) {	//Data Source checkbox
        		updateDataSourceIdentifiers( dataSourceId );
        	}//end if
        }//end if -- checked
    });
    
    
    //temporarily disable OEF/OIF Roster File data source
    $('form.dataSources input[type=checkbox]').on('change', function (e) {
    	e.preventDefault();

    	var dsId2 = "1033";

    	var dataSourceId = $(this).attr('data-id');
    	if( dataSourceId == dsId2 ) {
            var checkedVal = $(this).is(":checked");
        	if( checkedVal ) {
        		$('form.dataSources input[name=' + dsId2 + ']').removeAttr('checked');
        	}//end if
    	}//end if
    });
    
    
    //disable data sources (allow the data source to be removed, but not added)
    $('form.dataSources input[type=checkbox]').on('change', function (e) {
    	e.preventDefault();
    	
    	var dataSourceId = $(this).attr('data-id');
    	
        for (idx in data.disabledDataSources) {
            var dsID = data.disabledDataSources[idx];

	    	if( dataSourceId == dsID ) {
	            var checkedVal = $(this).is(":checked");
	        	if( checkedVal ) {
	        		//$('form.dataSources input[name=' + dsID + ']').removeAttr('checked');
	        		$(this).removeAttr('checked');
	        	}//end if
	        	
	        	return;
	    	}//end if -- found the dataSourceId
        }//end for
    });  
    // Capri VistAWeb Acces datasource selection is now based on participant's Capri Access selection
    $('form.dataSources input[name=1001]').attr('checked', (capriAccessParticipantsCount > 0) );
	// we make sure Real SSN is checked if more than one Capri access participant exists, 
	if (capriAccessParticipantsCount > 0)
		setRealSSNIdentifier(true);  
};


saveDataSourcesInformation = function (requestId, movingToNextPage) {

    // save the project data source selections

    var selection = $('form.dataSources select#location').find(':selected');
    var locationName = selection.val();


    //local server location
    var dataLoc = getSelectedDataSourceLocation();


    //get the list of selected data source ID values (currently static)
    var dataSources = getSelectedDataSourceIDList();
    //alert("dataSources = " + JSON.stringify(dataSources));

    //identifier checkboxes
    var realSSNIdentifier = $('form.dataSources input#realSSNIdentifier').is(':checked');
    var scrambledSSNIdentifier = $('form.dataSources input#scrambledSSNIdentifier').is(':checked');
    var phiDataIdentifier = $('form.dataSources input#phiIdentifier').is(':checked');


    var d2 = new Object();
    d2['userId'] = 5;
    d2['requestId'] = requestId;
    d2['locationName'] = locationName;
    d2['dataSources'] = dataSources;
    d2['realSSNIdentifier'] = realSSNIdentifier;
    d2['scrambledSSNIdentifier'] = scrambledSSNIdentifier;
    d2['phiDataIdentifier'] = phiDataIdentifier;

    d2['dataMart'] = dataLoc.dataMart; //flag values

    d2['movingToDocsPage'] = movingToNextPage; //moving to documents page?


    $.ajax({
        url: '../dart/saveRequestDataSources.json',
        type: 'POST',
        async: false,
        contentType: 'application/json',
		dataType:'json',
        data: JSON.stringify(d2),
        success: function (data, textStatus, three) {
            if (textStatus === "success") {

                if (movingToNextPage) {	//only get the documents if we're moving to the Documents page

                    // populate the document info (data sources affects the required documents)
                    listDocumentsByRequest(requestId, false);

                } 
            }
        }
    });

    return 0;
}


//disables all of the UI input controls if the request is not in an editable state
var disableAllUIControls = function () {

    //can only modify if the request is in an editable state
    if (editable == false) {

        $('div.tab-study-name:not(.docs)').each(function () {
            $(this).find('*').attr('disabled', true);
        });

        $('a[href=#participantModal]').attr('data-toggle', ''); //don't launch the Find Participant modal

        $("div.participant-select-location").attr('disabled', true).trigger("liszt:updated");	//disable the location chosen box
        

        $('.moreInfoIdentifiers a').removeAttr('disabled');	//don't disable the link to external info
    }
}


//saves the current page info (used for Save Draft and when the wizard moves to the next/prev page)
saveWizardPage = function (pageIndex, movingToNextPage) {

    //show spinner
    //	$('.bwizard-buttons .save button').hide();	//updated to match show(), below
    //	$('.bwizard-buttons #saveLoader > img:not([alt])').attr('alt', 'Saving').removeClass('hide');

    $('.bwizard-buttons .save button').hide();
    $('.bwizard-buttons #saveLoader').removeClass('hide');

    var resultCode = 0;
    if (pageIndex == 0 && editable) {
        //alert("1. @ saveProjectInformation, requestId = " + requestId);
        resultCode = saveProjectInformation(requestId);
    } else if (pageIndex == 1 && editable) {
        //alert("2. @ saveParticipantInformation, requestId = " + requestId);
        resultCode = saveParticipantInformation(requestId);
    } else if (pageIndex == 2 && editable) {

        //alert("3. @ saveDataSourcesInformation, requestId = " + requestId);
        resultCode = saveDataSourcesInformation(requestId, movingToNextPage);

    } else if (pageIndex == 3) {
        //alert("4. @ docs - nothing to do, requestId = " + requestId);

        //validate the request if we're moving forward to the submit page
        if (movingToNextPage) {
            resultCode = validateInputData(requestId);
        } //end if
    }

        //short delay to allow UI (spinner) to catch up before saving (IE bug fix)
        setTimeout( function(){
            //hide spinner
            //Changed a to button
            $('.bwizard-buttons .save button').show();
            $('.bwizard-buttons #saveLoader').addClass('hide');
        }, 100)

    return resultCode;
};

validateInputData = function (requestId) {

    var resultCode = 0;
    var requestIdMap = { "requestId": requestId };

    
    //if this is not the super-user, hide the super-user message container
    if( superUser == false ) {
    	$('#superUserMsgContainer').hide();
    }
    
    
    $.ajax({
        url: '../dart/validateRequest.json',
        type: 'POST',
        async: false,
        contentType: 'application/json',
		dataType:'json',
        data: JSON.stringify(requestIdMap),
        success: function (data, textStatus, three) {
            if (textStatus === "success") {
                if (data.errors.length !== 0) {
                    $('.submitTheRequest').hide();
                    
                    if (data.errors[0].indexOf("wrong state") !== -1) {	//request in wrong state
                        var errorMsgBody = Mustache.render($(".wrongStateMsgTemplate").html(), data);
                        $('#submitMsgContainer').html(errorMsgBody);
                    } else {                    	
                        var errorMsgBody = Mustache.render($(".errorMsgTemplate").html(), data);
                        $('#submitMsgContainer').html(errorMsgBody);
                    } //end else
                    
                } else {
                   	if( superUser == false || data.initiated == true ) {	//have not yet submitted this request
                		
	                    var successMsgBody = Mustache.render($(".successMsgTemplate").html(), data);
	                    //$('div.tab-study-name div.alert-container').html(successMsgBody);
	                    $('#submitMsgContainer').html(successMsgBody);
	                    $('.submitTheRequest').show();
	                    
                	} else {
	                    //
	                    //hide the validating progress bar (and the whole containing div)
	                    $('#submitMsgContainer').hide();
                	}
                }
                
                //
                //display the super-user specific messages
                if( superUser == true ) {
                    //display the state of the request
                    var superUserMsgTemplate = Mustache.render($(".superUserMsgTemplate").html(), data);
                    $('#superUserMsgContainer').html(superUserMsgTemplate);
                }                
            }
        }
    });

    //
    //the super-user can view requests, but cannot edit them
    if( superUser == true ) {
    	$('.submitTheRequest').hide();
    }    
    
    return resultCode;
}

//Save Draft wizard button	 	
$('html#requestor .bwizard-buttons').append('<li class="save"><button href="#" class="pull-right" type="button" role="button">Save Draft</button></li><img id="saveLoader" src="images/loader.gif" class="pull-right hide" alt="Saving">');
$('html#requestor .bwizard-buttons').on('click', '.save button', function (e) {
    //	alert("not doing something");
    //	e.preventDefault();

    //TODO: could just get the index directly from the wizard (rather than storing in an intermediate variable)
    //
    //determine which save function to call, based on which page we're currently on: currSaveIndex
    var resultCode = saveWizardPage(currSaveIndex, false); //saving only the current page (not moving to the next page)
});